//
//  GSShortCutItem.h
//  ShortCutPreferences
//
//  Created by Georg Seifert on 07.01.19.
//  Copyright © 2019 Georg Seifert. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSShortcutCommandProtocol;

typedef enum : NSUInteger {
	GSCommandTypeMainMenu,
	GSCommandTypeCustom,
} GSCommandType;

@interface GSShortcutItem : NSObject <NSCopying>

@property (nonatomic, strong) NSString *group;
@property (nonatomic, strong) NSString *name;
@property (nonatomic, strong) NSString *identifier;
@property (nonatomic) GSCommandType type;
@property (nonatomic) SEL action;
@property (nonatomic, weak) id target;

@property (nonatomic) uint16_t keyCode;
@property (nonatomic) NSEventModifierFlags modifierFlags;

@property (nonatomic, readonly) uint16_t defaultKeyCode;
@property (nonatomic, readonly) NSEventModifierFlags defaultModifierFlags;

@property (nonatomic, readonly) BOOL isDefault;
@property (weak) NSMenuItem *menuItem;

- (instancetype)initWithTitle:(NSString *)title group:(nullable NSString *)group identifier:(nullable NSString *)identifier action:(SEL)action target:(NSObject<GSShortcutCommandProtocol> *)target character:(nullable NSString *)character modifierFlags:(NSEventModifierFlags)modifierFlags;

- (void)keyCodeFromCharacter:(CFStringRef)character;
- (void)loadSettings;
- (void)storeInSettings;
- (void)removeFromSettings;
@end

NS_ASSUME_NONNULL_END
